#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex5-Creating data frames in R
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

#1.  Create a data frame  by considering 5 students and 4 events. Each event has a maximum score of 10. If a student participates in an event, its entry contains the score value and 0 otherwise.
name <- c("Anu","Swetha","Ravi","Raju","Bharathi")
event1  <- c(2,5,7,3,1)
event2 <- c(5,3,4,6,8)
event3  <- c(0,0,3,0,5)
event4  <- c(8,6,5,0,0)
events  <- data.frame(name,event1,event2,event3,event4)

#2.  View the contents of the data frame.
View(events)

#3.  Find the total score of each participant.
total_score <- rowSums(events[2:5])
print(total_score)

#4.  Append  a column to include the total score of the participants
events$totalscore <- total_score
View(events)

#5.  Find the maximum score and display the name of the participant who scored it.
print(max(events$totalscore))
print(name[which.max(events$totalscore)])

#6.  Compute the average score of each events and append it as a new row in the data frame.
events=rbind(events,data.frame(name="avg_score",event1=mean(events$event1),event2=mean(events$event2),event3=mean(events$event3),event4=mean(events$event4),totalscore=mean(events$totalscore)))
View(events)

#7.  Store the details in a comma separated values (csv) file.
write.csv(events,"Events.csv",row.names=FALSE)
